/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class TransferItemsRequestMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private ItemStack itemStack;
    private int quantity;
    private boolean attemptResolve;

    public TransferItemsRequestMessage() {
    }

    public TransferItemsRequestMessage(@NotNull IBuildingView building, ItemStack itemStack, int quantity, boolean attemptResolve) {
        super(building);
        this.itemStack = itemStack;
        this.quantity = quantity;
        this.attemptResolve = attemptResolve;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.quantity = buf.readInt();
        this.attemptResolve = buf.readBoolean();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.itemStack);
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.attemptResolve);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        int amountToTake;
        if (this.quantity <= 0) {
            Log.getLogger().warn("TransferItemsRequestMessage quantity below 0");
            return;
        }
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        boolean isCreative = player.m_7500_();
        Map<ItemStorage, ItemStorage> previousContent = null;
        if (isCreative) {
            amountToTake = this.quantity;
        } else {
            if (((Boolean)MineColonies.getConfig().getServer().debugInventories.get()).booleanValue()) {
                previousContent = InventoryUtils.getAllItemsForProviders((ICapabilityProvider)building.getTileEntity(), new IItemHandler[]{new InvWrapper((Container)player.m_150109_())});
            }
            amountToTake = Math.min(this.quantity, InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack, true, true)));
        }
        ItemStack remainingItemStack = ItemStack.f_41583_;
        int tempAmount = amountToTake;
        int i = 0;
        while ((double)i < Math.max(1.0, Math.ceil((double)amountToTake / (double)this.itemStack.m_41741_()))) {
            ItemStack itemStackToTake = this.itemStack.m_41777_();
            int insertAmount = Math.min(this.itemStack.m_41741_(), tempAmount);
            itemStackToTake.m_41764_(insertAmount);
            tempAmount -= insertAmount;
            remainingItemStack = InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)building.getTileEntity(), itemStackToTake);
            if (!remainingItemStack.m_41619_()) {
                tempAmount += remainingItemStack.m_41613_();
                break;
            }
            ++i;
        }
        if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue() || ItemStackUtils.getSize(remainingItemStack) != amountToTake) {
            building.getTileEntity().m_6596_();
        }
        if (ItemStackUtils.isEmpty(remainingItemStack).booleanValue() || ItemStackUtils.getSize(remainingItemStack) != amountToTake) {
            if (!isCreative) {
                ItemStack itemsTaken;
                for (int amountToRemoveFromPlayer = amountToTake - tempAmount; amountToRemoveFromPlayer > 0; amountToRemoveFromPlayer -= ItemStackUtils.getSize(itemsTaken)) {
                    int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.itemStack, true, true));
                    itemsTaken = player.m_150109_().m_7407_(slot, amountToRemoveFromPlayer);
                }
            }
            if (this.attemptResolve) {
                building.overruleNextOpenRequestWithStack(this.itemStack);
            }
        }
        if (!isCreative && previousContent != null && ((Boolean)MineColonies.getConfig().getServer().debugInventories.get()).booleanValue()) {
            InventoryUtils.doStorageSetsMatch(previousContent, InventoryUtils.getAllItemsForProviders((ICapabilityProvider)building.getTileEntity(), new IItemHandler[]{new InvWrapper((Container)player.m_150109_())}), true);
        }
    }
}

